#include <bits/stdc++.h>
using namespace std;

const long long P = 1000000007;

int n, m, t;
vector<int> a;

// Function to check if the given coloring is valid
bool is_valid_coloring(const vector<int>& colors, const vector<pair<int, int>>& edges) {
    for (const auto& edge : edges) {
        int u = edge.first;
        int v = edge.second;
        if (colors[u] == colors[v])
            return false;
    }
    return true;
}

// Recursive function to generate all possible colorings and count valid ones
void count_colorings(int idx, vector<int>& colors, int t_colors, const vector<pair<int, int>>& edges, long long& total) {
    if (idx == n) {
        if (is_valid_coloring(colors, edges))
            total += 1;
		total %= P;
        return;
    }
    for (int c = 0; c < t_colors; ++c) {
        colors[idx] = c;
        count_colorings(idx + 1, colors, t_colors, edges, total);
    }
}

int main() {
    cin >> n >> m >> t;
    a.resize(t);
    for (auto& x : a)
        cin >> x;

    vector<pair<int, int>> e;
    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        e.push_back({u, v});
    }

    for (int colors_needed : a) {
        vector<int> colors(n, 0);
        long long total_valid_colorings = 0;
        count_colorings(0, colors, colors_needed, e, total_valid_colorings);
		cout << total_valid_colorings << '\n';
    }

    return 0;
}
