#include <bits/stdc++.h>
using namespace std;
using ll=long long;
using pii=pair<int,int>;
constexpr ll MOD = 1000000007;
struct graph
{
	graph(int n):n(n){}
	void add(int u, int v)
	{
		if(u>v)swap(u,v);
		edges.insert({u,v});
	}
	bool operator<(const graph& h) const
	{
		return tie(n,edges) < tie(h.n,h.edges);
	}
	int n;
	set<set<int>> edges;
};

map<graph,vector<ll>> cache;

vector<ll> chp(graph g)
{
	if(g.n==0)return{1};
	if(g.edges.empty())
	{
		vector<ll> res(g.n+1,0);
		res[g.n]=1;
		return res;
	}
	if(cache.count(g))
		return cache[g];
	auto u = *g.edges.begin()->begin();
	auto v = *++g.edges.begin()->begin();
	graph gd = g;
	gd.edges.erase(gd.edges.begin());
	graph gc=(g.n-1);
	for(auto& s : g.edges)
	{
		if(s == *g.edges.begin()) continue;
		auto uu = *s.begin();
		auto vv = *++s.begin();
		if(uu==v)uu=u;
		if(vv==v)vv=u;
		if(uu==vv)continue;
		if(uu>v)--uu;
		if(vv>v)--vv;
		gc.add(uu,vv);
	}
	auto p1=chp(gd);
	auto p2=chp(gc);
	
	int maxd=max(p1.size(),p2.size());
	vector<ll> res(maxd,0);
	for(int i = 0; i < p1.size(); ++i)
		res[i]=p1[i];
	for(int i = 0; i < p2.size(); ++i)
		res[i] = (res[i] - p2[i]+ MOD)%MOD;
	return cache[g]=res;
}

int main()
{
	int n, m,t;
	cin >> n >> m >> t;
	graph g(n);
	vector<int> a(t);
	for(auto&x:a)cin>>x;
	for(int i = 0; i < m; ++i)
	{
		int u,v;
		cin>>u>>v;
		g.add(u,v);
	}
	auto poly = chp(g);
	for(auto k : a)
	{
		ll res=0;
		ll p=1;
		for(ll c : poly)
		{
			res = (res + c * p) % MOD;
			p = (p * k) % MOD;
		}
		cout << res << '\n';
	}
}
