#include <bits/stdc++.h>

typedef long long ll;

using namespace std;

ll prime = 1000000007;

int n = 0;
vector<vector<int>> adj;
vector<bool> used;

void dfs(int v) {
    used[v] = true;
    for (int u: adj[v]) {
        if (!used[u])
            dfs(u);
    }
}

int find_comps() {
    int comp = 0;
    used.clear();
    used.resize(n);
    for (int i = 0; i < n; ++i) {
        if (!used[i]) {
            comp++;
            dfs(i);
        }
    }
    return comp;
}

ll power(ll x, ll y, ll p) {
    ll res = 1;

    x = x % p;

    if (x == 0) return 0;

    while (y > 0) {
        if (y & 1)
            res = (res * x) % p;

        y = y >> 1;
        x = (x * x) % p;
    }
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    ll m, t;
    cin >> n >> m >> t;
    vector<ll> a(t);
    for (auto &it: a) cin >> it;
    vector<pair<int, int>> edges(m);
    for (int i = 0; i < m; ++i) {
        cin >> edges[i].first >> edges[i].second;
    }

    vector<ll> poly(n + 1);
    for (ll i = 0; i < (ll) pow(2, m); ++i) {
        adj.clear();
        adj.resize(n);
        ll temp = i, curEdges = 0;
        for (int j = 0; j < m; ++j) {
            if (temp % 2 == 1) {
                adj[edges[j].first].emplace_back(edges[j].second);
                adj[edges[j].second].emplace_back(edges[j].first);
                curEdges++;
            }
            temp /= 2;
        }
        ll comp = find_comps();
        if (curEdges % 2 == 0) poly[comp]++;
        else poly[comp]--;
    }

    for (int i = 0; i < t; ++i) {
        ll ans = 0;
        for (int j = 0; j <= n; ++j) {
            ans = (prime + ans + (poly[j] * power(a[i], j, prime)) % prime) % prime;
        }
        cout << ans << endl;
    }

    return 0;
}