import java.util.Scanner;
import java.util.Arrays;

/**
 * ICPC - CTU Open Contest 2025
 * Sample Solution: ornithology
**/


public class OrnithologyPC {

  public static int signum(long val) {
    return (val > 0 ? 1 : (val < 0 ? -1 : 0));
  }

  public static void main(String[] args) {
    Scanner scanner = new Scanner(System.in);
    int N = scanner.nextInt();
    int D = scanner.nextInt();
    long[][] pos = new long[N][D];
    for (int i = 0; i < N; ++i)
      for (int j = 0; j < D; ++j)
        pos[i][j] = scanner.nextInt();
    
    if (N == 1) {
      System.out.println(0);
    }

    // Find a non-constant coordinate.
    int nonconst = 0;
    for (int j = 0; j < D; ++j)
    {
      boolean con = true;
      for (int i = 1; i < N; ++i)
        if (pos[i][j] != pos[0][j]) {
          con = false;
          break;
        }
      if (!con) {
        nonconst = j;
        break;
      }
    }
    // Move the non-constant coordinate to the beginning.
    // We want it non-constant because initial sorting will be based solely on it.
    for (int i = 0; i < N; ++i) {
      long tmp = pos[i][nonconst];
      pos[i][nonconst] = pos[i][0];
      pos[i][0] = tmp;
    }

    // Initial ordering, looking only at coordinate 0. If 0-th coordinate is equal
    // for many points, then the final ordering may be very different.
    Arrays.sort(pos, (a, b) -> Long.compare(a[0], b[0]));

    // In the final ordering, we want all coordinates either ascending, descending,
    // or constant. Constant ones are easy, but distinguishing ascending and
    // descending is tricky in cases when many points have that coordinate equal.
    //
    // Is the coordinate ascending? 1 = yes, -1 = no, 0 = constant coordinate
    int asc[] = new int[D];
    asc[0] = 1;
    for (int j = 1; j < D; ++j)
    {
      boolean con = true;
      int i = 1;
      while(i < N && pos[i][j] == pos[0][j]) ++i;
      // i = first point where j-th coordinate differs from the point 0
      if (i == N) continue; // the coordinate is constant
      if (pos[i][0] != pos[0][0]) {
        // 0-th coordinate differs, so pt i will be after pt 0 in final ordering
        asc[j] = signum(pos[i][j] - pos[0][j]);
      } else {
        // final ordering of i and 0 is unknown, let's go where ordering is known
        int k = i + 1;
        while (k < N && pos[k][0] == pos[0][0]) ++k;
        // k = first point where 0-th coordinate differs from the previous points
        if (pos[k][j] != pos[0][j])
          asc[j] = signum(pos[k][j] - pos[0][j]);
        else // pos[k][j] != pos[i][j]
          asc[j] = signum(pos[k][j] - pos[i][j]);
      }
    }

    // Final ordering.
    Arrays.sort(pos, (a, b) -> {
        for (int j = 0; j < a.length; ++j)
          if (a[j] != b[j]) return Long.compare(a[j], b[j]) * asc[j];
        return 0;
    });

    // If the birds are not ordered in some dimension, then can't be embedded on the line.
    for (int j = 0; j < D; ++j) {
      for (int i = 1; i < N; ++i) {
        int sgn = signum(pos[i][j] - pos[i - 1][j]);
        if (sgn != 0 && sgn != asc[j]) {
          System.out.println("-1");
          return;
        }
      }
    }
  
    int mid = N / 2;
    // Manhattan distance to the midpoint.
    long[] dst2mid = new long[N];
    long sumdst = 0;
    for (int i = 0; i < N; ++i) {
      dst2mid[i] = 0;
      for (int j = 0; j < D; ++j)
        dst2mid[i] += Math.abs(pos[i][j] - pos[mid][j]);
      sumdst += dst2mid[i];
    }

    long result = -1;
    for (int j = 0; j < D; ++j) {
      long cur = 0;
      // Each point moves to the midpoint in all coordinates except the j-th.
      // Then the point moves along the j-th coordinate the same distance away
      // from the midpoint, so that it ends up at the same distance from the
      // midpoint as at the beginning. 
      for (int i = 0; i < N; ++i)
        cur += 2 * (dst2mid[i] - Math.abs(pos[i][j] - pos[mid][j]));

      if (result == -1 || cur < result)
        result = cur;
    }
    System.out.println(result);
  }
}
