#include <bits/stdc++.h>

typedef long long ll;

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    ll n, d;
    cin >> n >> d;
    vector<vector<ll>> a(n);
    for (ll i = 0; i < n; ++i) {
        a[i].resize(d);
        for (auto &it: a[i]) cin >> it;
    }
    vector<ll> ma, mi, dir(d), steps(d);
    ma.assign(d, -LONG_LONG_MAX), mi.assign(d, LONG_LONG_MAX);
    ll first = 0, second = 0;
    for (ll i = 0; i < d; ++i) {
        for (ll j = 0; j < n; ++j) {
            ma[i] = max(ma[i], a[j][i]);
            mi[i] = min(mi[i], a[j][i]);
        }
    }

    ll prime = 1e9 + 7;
    ll num = 47;
    map<ll, ll> curNums;
    for (int i = 0; i < n; ++i) {
        ll curSeq = 0, revSeq = 0;
        ll curMul = 1;
        bool pos = true;
        for (int j = 0; j < d; ++j) {
            if (ma[j] == mi[j]) continue;
            if (a[i][j] == ma[j]) {
                curSeq = (curSeq + curMul) % prime;
            } else if (a[i][j] == mi[j]) revSeq = (revSeq + curMul) % prime;
            else {
                pos = false;
                break;
            }
            curMul = (curMul * num) % prime;
        }
        if (!pos) continue;
        if (curNums.count(revSeq) != 0) {
            first = curNums[revSeq];
            second = i;
            break;
        }
        curNums[curSeq] = i;
    }

    for (ll i = 0; i < d; ++i) {
        if (a[first][i] == mi[i] && a[second][i] == ma[i]) dir[i] = 1;
        else if (a[second][i] == mi[i] && a[first][i] == ma[i]) dir[i] = -1;
        else {
            cout << -1 << endl;
            return 0;
        }
    }
    sort(a.begin(), a.end(), [&d, &dir](vector<ll> &x, vector<ll> &y) {
        for (ll i = 0; i < d; ++i) {
            if (x[i] == y[i]) continue;
            return dir[i] * x[i] < dir[i] * y[i];
        }
        return x[0] < y[0];
    });
    for (ll i = 0; i < d; ++i) {
        for (ll j = 1; j < n; ++j) {
            if (dir[i] * a[j][i] < dir[i] * a[j - 1][i]) {
                cout << -1 << endl;
                return 0;
            }
        }
    }
    ll sum = 0;
    for (ll i = 0; i < d; ++i) {
        for (ll j = 1; j <= n / 2; ++j) {
            steps[i] += j * abs(a[j][i] - a[j - 1][i]);
        }
        for (ll j = n - 1; j > n / 2; --j) {
            steps[i] += (n - j) * abs(a[j][i] - a[j - 1][i]);
        }
        sum += steps[i];
    }

    ll ans = LONG_LONG_MAX;
    for (ll i = 0; i < d; ++i) {
        ans = min(ans, 2 * (sum - steps[i]));
    }
    cout << ans << endl;

    /*ll ans = 0;
    vector<ll> diff(d);
    for (int i = 0; i < d; ++i) {
        diff[i] = abs(a[0][i] - a[1][i]);
    }
    sort(diff.begin(), diff.end());
    for (int i = 0; i < d - 1; ++i) {
        ans += 2 * diff[i];
    }
    cout << ans << endl;*/

    return 0;
}