#include <iostream>
#include <vector>
#include <set>
#include <map>
#include <algorithm>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, C, Q;
    cin >> N >> C >> Q;

    // Read the intervals in which officials are in Prague
    vector<pair<int, int>> officials(N);
    map<int, vector<int>> starts; // day -> list of interval indices that start
    map<int, vector<int>> ends;   // day -> list of interval indices that end
    int minDay = 200001, maxDay = 0;
    
    for (int i = 0; i < N; ++i) {
        cin >> officials[i].first >> officials[i].second;
        starts[officials[i].first].push_back(i);
        ends[officials[i].second].push_back(i);
        minDay = min(minDay, officials[i].first);
        maxDay = max(maxDay, officials[i].second);
    }

    // Read the initial meeting days
    set<int> meetingDays;
    for (int i = 0; i < C; ++i) {
        int day;
        cin >> day;
        meetingDays.insert(day);
    }

    // Read the queries
    vector<pair<int, int>> queries(Q);
    for (int i = 0; i < Q; ++i) {
        cin >> queries[i].first >> queries[i].second;
    }

    // Lambda to calculate uncovered intervals using sweep line
    auto calculateUncovered = [&]() -> int {
        // Sweep through all days from minDay to maxDay
        set<int> openIntervals; // indices of currently open intervals
        int uncovered = 0;
        
        for (int day = minDay; day <= maxDay; ++day) {
            // Open intervals starting at this day
            if (starts.count(day)) {
                for (int idx : starts[day]) {
                    openIntervals.insert(idx);
                }
            }
            
            // If this is a meeting day, remove all open intervals (they are now covered)
            if (meetingDays.count(day)) {
                openIntervals.clear();
            }
            
            // Close intervals ending at this day
            // If they're still in openIntervals, they were never covered
            if (ends.count(day)) {
                for (int idx : ends[day]) {
                    if (openIntervals.count(idx)) {
                        uncovered++;
                        openIntervals.erase(idx);
                    }
                }
            }
        }
        
        return uncovered;
    };

    // Print the initial count of uncovered intervals
    cout << calculateUncovered() << '\n';

    // Process each query
    for (const auto &query : queries) {
        int from = query.first, to = query.second;
        // Move the meeting day from 'from' to 'to'
        meetingDays.erase(from);
        meetingDays.insert(to);

        // Calculate and print the new count of uncovered intervals
        cout << calculateUncovered() << '\n';
    }

    return 0;
}
