#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

using namespace std;
#define MAX 200009
vector<pair<int,int>> intervals;

void insert(int x, int y)
{
    intervals.push_back({x,y});
}

int inside_interval(int x, int y)
{
    int cnt = 0;
    for(auto&[xx,yy] : intervals)
        if(x <= xx & yy <= y)
            cnt++;
    return cnt;
}

int main()
{
    int N, C, Q;
    cin >> N >> C >> Q;
    for (int i = 0; i < N; ++i) {
        int x, y;
        cin >> x >> y;
        insert(x, y);
    }
    set<int> cats = {0, MAX - 1};
    for (int i = 0; i < C; ++i) {
        int c;
        cin >> c;
        cats.insert(c);
    }
    int uncovered = 0;
    for (auto it = next(cats.begin()); it != cats.end(); ++it) {
        int l = *prev(it);
        int r = *it;
        uncovered += inside_interval(l + 1, r - 1);
    }
    
    auto remove_cat = [&](int c)
    {
        assert(cats.count(c));
        //c prev, c next (cp,cn)
        int cp = *prev(cats.find(c));
        int cn = *next(cats.find(c));
        uncovered += inside_interval(cp + 1, cn - 1);
        uncovered -= inside_interval(cp + 1, c - 1);
        uncovered -= inside_interval(c + 1, cn - 1);
        cats.erase(c);
    };
    
    auto put_cat =[&](int c)
    {
        assert(!cats.count(c));
        int cn = *cats.upper_bound(c);
        int cp = *prev(cats.upper_bound(c));
        uncovered -= inside_interval(cp+1,cn-1);
        uncovered += inside_interval(cp+1,c-1);
        uncovered += inside_interval(c+1,cn-1);
        cats.insert(c);
    };
    cout << uncovered << '\n';
    
    for (int i = 0; i < Q; ++i) {
        int from, to;
        cin >> from >> to;
        assert(cats.count(from));
        remove_cat(from);
        put_cat(to);
        cout << uncovered << '\n';
    }
    return 0;
}



