import java.util.*;

public class zlava {
    static final int MX = 200001;

    static class Fenwick2D {
        private final int n;
        private final int m;
        private final Map<Integer, Map<Integer, Integer>> tree;

        public Fenwick2D(int n, int m) {
            this.n = n;
            this.m = m;
            this.tree = new HashMap<>();
        }

        public void add(int x, int y, int delta) {
            for (int xi = x; xi <= n; xi += xi & -xi) {
                tree.putIfAbsent(xi, new HashMap<>());
                Map<Integer, Integer> row = tree.get(xi);
                for (int yi = y; yi <= m; yi += yi & -yi) {
                    row.put(yi, row.getOrDefault(yi, 0) + delta);
                }
            }
        }

        public int prefixSum(int x, int y) {
            int res = 0;
            for (int xi = x; xi > 0; xi -= xi & -xi) {
                Map<Integer, Integer> row = tree.get(xi);
                if (row != null) {
                    for (int yi = y; yi > 0; yi -= yi & -yi) {
                        res += row.getOrDefault(yi, 0);
                    }
                }
            }
            return res;
        }

        public int queryRect(int x1, int y1, int x2, int y2) {
            return prefixSum(x2, y2)
                 - prefixSum(x1 - 1, y2)
                 - prefixSum(x2, y1 - 1)
                 + prefixSum(x1 - 1, y1 - 1);
        }
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int N = scanner.nextInt();
        int C = scanner.nextInt();
        int Q = scanner.nextInt();

        Fenwick2D F = new Fenwick2D(MX, MX);

        for (int i = 0; i < N; i++) {
            int x = scanner.nextInt();
            int y = scanner.nextInt();
            F.add(x, y, 1);
        }

        TreeSet<Integer> S = new TreeSet<>();
        S.add(0);
        S.add(200002);

        int[] T = {N};
        Map<String, Integer> rectCache = new HashMap<>();

        // Helper methods wrapped inside main for single-file convenience
        java.util.function.BiFunction<Integer, Integer, Integer> getRect = (x, y) -> {
            if (x > y) return 0;
            String key = x + "," + y;
            return rectCache.computeIfAbsent(key, k -> F.queryRect(x, x, y, y));
        };

        java.util.function.IntFunction<Integer> gin = (x) -> {
            Integer l = S.lower(x);
            Integer r = S.higher(x);
            if (l == null || r == null) return 0;
            return getRect.apply(l + 1, r - 1)
                 - getRect.apply(l + 1, x - 1)
                 - getRect.apply(x + 1, r - 1);
        };

        java.util.function.IntConsumer add = (x) -> {
            T[0] -= gin.apply(x);
            S.add(x);
        };

        java.util.function.IntConsumer erase = (x) -> {
            S.remove(x);
            T[0] += gin.apply(x);
        };

        for (int i = 0; i < C; i++) {
            int c = scanner.nextInt();
            add.accept(c);
        }

        System.out.println(T[0]);

        for (int i = 0; i < Q; i++) {
            int l = scanner.nextInt();
            int nVal = scanner.nextInt();
            erase.accept(l);
            add.accept(nVal);
            System.out.println(T[0]);
        }
    }
}
