#include <bits/stdc++.h>

typedef long long ll;

using namespace std;

vector<int> t;

int sum(int v, int tl, int tr, int l, int r) {
    if (l > r)
        return 0;
    if (l == tl && r == tr) {
        return t[v];
    }
    int tm = (tl + tr) / 2;
    return sum(v * 2, tl, tm, l, min(r, tm)) +
           sum(v * 2 + 1, tm + 1, tr, max(l, tm + 1), r);
}

void update(int v, int tl, int tr, int pos, int new_val) {
    if (tl == tr) {
        t[v] = new_val;
    } else {
        int tm = (tl + tr) / 2;
        if (pos <= tm)
            update(v * 2, tl, tm, pos, new_val);
        else
            update(v * 2 + 1, tm + 1, tr, pos, new_val);
        t[v] = t[v * 2] + t[v * 2 + 1];
    }
}

ll n, c, q;
vector<ll> a;
vector<pair<ll, ll>> changes, neededQ;
map<pair<ll, ll>, ll> qAns;

void check() {
    set<ll> curC;
    curC.insert(0), curC.insert(200001);
    for (int i = 0; i < a.size(); ++i) {
        ll l = *(--curC.upper_bound(a[i])), r = *curC.upper_bound(a[i]);
        neededQ.emplace_back(l + 1, r - 1);
        if (l + 1 < a[i]) neededQ.emplace_back(l + 1, a[i] - 1);
        if (a[i] + 1 < r) neededQ.emplace_back(a[i] + 1, r - 1);
        curC.insert(a[i]);
    }
    for (int i = 0; i < changes.size(); ++i) {
        ll cur = changes[i].first;
        curC.erase(cur);
        ll l = *(--curC.upper_bound(cur)), r = *curC.upper_bound(cur);
        neededQ.emplace_back(l + 1, r - 1);
        if (l + 1 < cur) neededQ.emplace_back(l + 1, cur - 1);
        if (cur + 1 < r) neededQ.emplace_back(cur + 1, r - 1);

        cur = changes[i].second;
        l = *(--curC.upper_bound(cur)), r = *curC.upper_bound(cur);
        neededQ.emplace_back(l + 1, r - 1);
        if (l + 1 < cur) neededQ.emplace_back(l + 1, cur - 1);
        if (cur + 1 < r) neededQ.emplace_back(cur + 1, r - 1);
        curC.insert(cur);
    }
}

void solve() {
    set<ll> curC;
    curC.insert(0), curC.insert(200001);
    ll curAns = 0;
    for (int i = 0; i < a.size(); ++i) {
        ll l = *(--curC.upper_bound(a[i])), r = *curC.upper_bound(a[i]);
        ll total = qAns[make_pair(l + 1, r - 1)], left = 0, right = 0;
        if (l + 1 < a[i]) left = qAns[make_pair(l + 1, a[i] - 1)];
        if (a[i] + 1 < r) right = qAns[make_pair(a[i] + 1, r - 1)];
        curAns += total - left - right;
        curC.insert(a[i]);
    }
    cout << n - curAns << endl;
    for (int i = 0; i < changes.size(); ++i) {
        ll cur = changes[i].first;
        curC.erase(cur);
        ll l = *(--curC.upper_bound(cur)), r = *curC.upper_bound(cur);
        ll total = qAns[make_pair(l + 1, r - 1)], left = 0, right = 0;
        if (l + 1 < cur) left = qAns[make_pair(l + 1, cur - 1)];
        if (cur + 1 < r) right = qAns[make_pair(cur + 1, r - 1)];

        curAns -= total - left - right;

        cur = changes[i].second;
        l = *(--curC.upper_bound(cur)), r = *curC.upper_bound(cur);
        total = qAns[make_pair(l + 1, r - 1)], left = 0, right = 0;
        if (l + 1 < cur) left = qAns[make_pair(l + 1, cur - 1)];
        if (cur + 1 < r) right = qAns[make_pair(cur + 1, r - 1)];
        curC.insert(cur);

        curAns += total - left - right;
        cout << n - curAns << endl;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cin >> n >> c >> q;
    t.resize(1e6);
    vector<pair<ll, ll>> intervals(n);
    vector<vector<ll>> intEnds(200001), qEnds(200001);
    for (int i = 0; i < n; ++i) {
        cin >> intervals[i].first >> intervals[i].second;
        intEnds[intervals[i].first].emplace_back(intervals[i].second);
    }
    a.resize(c);
    for (auto &it: a) cin >> it;
    changes.resize(q);
    for (int i = 0; i < q; ++i) {
        cin >> changes[i].first >> changes[i].second;
    }

    check();
    for (auto &i: neededQ) {
        qEnds[i.first].emplace_back(i.second);
    }

    for (int i = 200000; i > 0; --i) {
        for (long long j: intEnds[i]) {
            int x = sum(1, 0, 200000, j, j);
            update(1, 0, 200000, j, x + 1);
        }
        for (long long j: qEnds[i]) {
            int x = sum(1, 0, 200000, i, j);
            qAns[make_pair(i, j)] = x;
        }
    }
    solve();

    return 0;
}