#include <bits/stdc++.h>
using namespace std;
using ll=long long;
using ld=double;
using vll=vector<ll>;
using vvll=vector<vector<ll>>;
#define FOR(i,a,b) for(ll i=a;i<(ll)b;++i)
#define F(n) FOR(i,0,n)
#define FF(n) FOR(j,0,n)
#define aa first
#define bb second
#define PB push_back
#define EQ(a,b) (fabs(a-b)<=(fabs(a+b)*EPS))
#define MOD ((ll)(1e9+7))
#define dbg cerr
// #define dbg if(0) cerr
#define out(n) cout << n << '\n'

ll s[2][200][200];
ll g[200][200];


ll n, m;
ll edgeIdx(ll r1, ll c1, ll r2, ll c2) {
  if (r1 > r2) swap(r1, r2);
  if (c1 > c2) swap(c1, c2);
  assert((r1 == r2) ^ (c1 == c2));
  assert(abs(r1-r2) + abs(c2-c1) == 1);
  assert(c2 <= m);
  assert(r2 <= n);

  ll horizontalEdges = (n+1)*m;
  ll res;
  // ll verticalEdges = n*(m+1);
  if (r1 == r2) { // horizontal
    res = r1*m + c1;
  } else { // vertical
    res = horizontalEdges + r1*(m+1) + c1;
  }
  return res;
}

// Gauss elimination over GF(2)
int gauss_mod2(vector<vector<long long int>> mat) {
    int n = mat.size();       // number of rows
    if (n == 0) return 0;
    int m = mat[0].size();    // number of columns

    int rank = 0;

    for (int col = 0; col < m && rank < n; ++col) {
        int pivot = -1;
        for (int row = rank; row < n; ++row) {
            if (mat[row][col] % 2) {
                pivot = row;
                break;
            }
        }

        if (pivot == -1) continue;

        swap(mat[rank], mat[pivot]);

        for (int row = 0; row < n; ++row) {
            if (row != rank && (mat[row][col] % 2)) {
                for (int k = col; k < m; ++k) {
                    mat[row][k] = (mat[row][k] + mat[rank][k]) % 2;
                }
            }
        }

        ++rank;
    }

    dbg << "rank: " << rank << endl;
    return rank;
}

int main(){
  ios::sync_with_stdio(0);cin.tie(0);
  cin>>n>>m;
  for (int k = 0; k < 2; ++ k) {
    F(2*n+1){
      FF(m + (i%2)) {
        cin>>s[k][i][j];
      }
    }
  }
  F(2*n+1){
    FF(m + (i%2)) {
      s[0][i][j]^=s[1][i][j];
    }
  }

  // basis
  vvll b;
  ll E = (n+1)*m + n*(m+1);
  dbg << "E: " << E << endl;

  // add all rectangles
  F(n) {
    FF(m) { 
      for (int ii = i+1; ii < n+1; ++ ii) {
        for (int jj = j+1; jj < m+1; ++ jj) {
          vll row(E);

          // vertical edges
          for (int r = i; r < ii; ++ r) {
            row[edgeIdx(r,j,r+1,j)] = 1;
            row[edgeIdx(r,jj,r+1,jj)] = 1;
          }

          // horizontal edges
          for (int c = j; c < jj; ++ c) {
            row[edgeIdx(i,j,i,j+1)] = 1;
            row[edgeIdx(ii,j,ii,j+1)] = 1;
          }

          b.push_back(row);
        }
      }
    }
  }

  // add all horizontal lines
  F(n+1) {
    vll row(E);
    FF(m) { 
      row[edgeIdx(i,j,i,j+1)] = 1;
    }
    b.push_back(row);
  }

  // add all vertical lines
  FF(m+1) {
    vll row(E);
    F(n) { 
      row[edgeIdx(i,j,i+1,j)] = 1;
    }
    b.push_back(row);
  }

  // compute dimension of this matrix
  ll dim = gauss_mod2(b);

  // add the solution vector
  vll solRow(E);
  F(2*n+1) {
    FF(m + (i%2)) {
      ll r = (i/2);
      ll nr = ((i/2)+1);
      ll c = j;
      ll nc = (j+1);

      if (i%2 == 0) { // horizontal edges
        solRow[edgeIdx(r,c,r,nc)] = s[0][i][j];
      } else {
        solRow[edgeIdx(r,c,nr,c)] = s[0][i][j];
      }
    }
  }

  dbg << "rows: " << b.size() << endl;

  b.push_back(solRow);
  ll dim2 = gauss_mod2(b);
  dbg << dim << ", " << dim2 << endl;

  cout << (dim2 == dim ? "Yes" : "No") << endl;

  return 0;
}
