#include <bits/stdc++.h>

using namespace std;

int main()
{
    int n, m;
    cin >> n >> m;
    bool horizontal = true;
    using vertex = pair<int, int>;
    using edge = pair<vertex, vertex>;
    map<edge, int> edges;
    
    for (int i = 0; i < 2 * n + 1; ++i) {
        if (horizontal) {
            for (int j = 0; j < m; ++j) {
                vertex u = {(i / 2), j};
                vertex v = {(i / 2), (j + 1)};
                int x;
                cin >> x;
                edges[{u, v}] ^= x;
                //cerr << "(" << u.first << "," << u.second << ") -- (" << v.first << "," << v.second << "), " << x << endl;
            }
        }
        else {
            for (int j = 0; j < m + 1; ++j) {
                vertex u = {(i / 2), j};
                vertex v = {((i / 2) + 1), j};
                int x;
                cin >> x;
                edges[{u, v}] ^= x;
                //cerr << "(" << u.first << "," << u.second << ") -- (" << v.first << "," << v.second << "), " << x << endl;
            }
        }
        horizontal = !horizontal;
    }
    horizontal = true;
    cerr << '\n';
    for (int i = 0; i < 2 * n + 1; ++i) {
        if (horizontal) {
            for (int j = 0; j < m; ++j) {
                vertex u = {(i / 2), j};
                vertex v = {(i / 2), (j + 1)};
                int x;
                cin >> x;
                edges[{u, v}] ^= x;
                //cerr << "(" << u.first << "," << u.second << ") -- (" << v.first << "," << v.second << "), " << x << endl;
            }
        }
        else {
            for (int j = 0; j < m + 1; ++j) {
                vertex u = {(i / 2), j};
                vertex v = {((i / 2) + 1), j};
                int x;
                cin >> x;
                edges[{u, v}] ^= x;
                //cerr << "(" << u.first << "," << u.second << ") -- (" << v.first << "," << v.second << "), " << x << endl;
            }
        }
        horizontal = !horizontal;
    }
    
    
    auto all_zeroes = [&]()
    {
        map<edge,int> z;
        for(auto&[k,_] : edges)
            z[k] = 0;
        return z;
    };
    
    auto all_cycles = [&](int n, int m)->set<map<edge,int>>
    {
        set<map<edge,int>> res;
        for(int i = 0; i < n; ++i)
            for(int j = 0; j < m; ++j)
            {
                auto az = all_zeroes();
                az[{{i,j},{i+1,j}}] = 1;
                az[{{i+1,j},{i+1,j+1}}] = 1;
                az[{{i,j+1},{i+1,j+1}}] = 1;
                az[{{i,j},{i,j+1}}] = 1;
                res.insert(az);
            }
        
        for(int i = 0; i < n + 1; ++i)
        {
            //horizontal lines
            auto az = all_zeroes();
            for(int j = 0; j < m; ++j)
                az[{{i,j},{i,j+1}}]=1;
            res.insert(az);
        }
        for(int j = 0; j < m + 1; ++j)
        {
            //vertical lines
            auto az = all_zeroes();
            for(int i = 0; i < n; ++i)
                az[{{i,j},{i+1,j}}]=1;
            res.insert(az);
        }
        return res;
    };
    
    
    auto do_xor = [](const map<edge,int>& a, const map<edge,int>& b)
    {
        /*set<edge> A,B;
        for(auto&[k,v]:a)
            A.insert(k);
        for(auto&[k,v]:b)
            B.insert(k);
        assert(A==B);*/
        
        map<edge,int> r;
        for(auto& [k,v] : a)
            r[k]=v^b.at(k);
        return r;
    };
    
    auto p = [](const map<edge,int>& e)
    {
        for(auto&[k,v] : e)
        {
            auto x = k.first;
            auto y = k.second;
            cout << "(" << x.first << "," << x.second << ") -- (" << y.first << "," << y.second << ") : " << v << '\n';
        }
    };
    
    
    using state = map<edge,int>;
    
    set<state> seen;
    queue<state> Q;
    Q.push(edges);
    seen.insert(edges);
    const auto zero = all_zeroes();
    const auto AC = all_cycles(n,m);
    
    while(!Q.empty())
    {
        auto u = Q.front();
        Q.pop();
        
        for(auto& C : AC)
        {
            auto v = do_xor(C,u);
            if(v == zero) {
                cout << "Yes\n";
                return 0;
            }
            if(seen.insert(v).second)
                Q.push(v);
        }
    }
    cout << "No\n";
    
    return 0;
}

