import sys
from copy import deepcopy
from itertools import chain
sys.setrecursionlimit(1000000)
def D(a):print(a)
def line():return sys.stdin.readline().strip()
def next_int():return int(line())
def line_ints():return list(map(int,line().split(" ")))

N, M = line_ints()
MATRIX = [line_ints() for _ in range(N*2+1)]
CHANGE = [line_ints() for _ in range(N*2+1)]
FLAT_MATRIX = list(chain.from_iterable(MATRIX))
FLAT_CHANGE = list(chain.from_iterable(CHANGE))
FINAL = [a^b for a, b in zip(FLAT_MATRIX, FLAT_CHANGE)]

def gauss(mat):
    mat = deepcopy(mat)
    n, m = len(mat), len(mat[0])
    rank = row = 0

    for col in range(m):
        pivot = -1
        for i in range(row, n):
            if mat[i][col]:
                pivot = i
                break

        if pivot == -1:
            continue

        mat[row], mat[pivot] = mat[pivot], mat[row]

        for i in range(n):
            if i != row and mat[i][col]:
                for j in range(col, m):
                    mat[i][j] ^= mat[row][j]

        row += 1
        rank += 1

    return m - rank

def nr(i, j):
    return j + i//2*(M+1) + (i+1)//2*M

def ini():
    return [0] * len(FINAL)

def row(i):
    a = ini()
    for j in range(M):
        a[nr(i*2, j)] = 1
    return a

def col(j):
    a = ini()
    for i in range(N):
        a[nr(i*2+1, j)] = 1
    return a

def sqr(i, j):
    a = ini()
    a[nr(2*i, j)] = 1
    a[nr(2*i+2, j)] = 1
    a[nr(2*i+1, j)] = 1
    a[nr(2*i+1, j+1)] = 1
    return a

gem = [row(i) for i in range(N+1)] + [col(j) for j in range(M+1)] + [sqr(i, j) for i in range(N) for j in range(M)]

x = gauss(gem)
y = gauss(gem + [FINAL])
print("No" if x != y else "Yes")
