import java.util.Scanner;
import java.util.Arrays;

/**
 * ICPC - CTU Open Contest 2025
 * Sample Solution: janosik
**/

public class JanosikPC {
  public static boolean[][] deepCopy(boolean[][] orig) {
    final boolean[][] result = new boolean[orig.length][];
    for (int i = 0; i < orig.length; i++) {
        result[i] = Arrays.copyOf(orig[i], orig[i].length);
    }
    return result;
  }  

  // Solve depending on whether first row was flipped or not.
  public static boolean solve(int N, int M, boolean[][] row, boolean[][] col, boolean frf) {
    boolean nrow[][] = deepCopy(row);
    boolean ncol[][] = deepCopy(col);
    for (int j = 0; j < M; ++j)
      nrow[0][j] ^= frf;

    // The values in the first row determine which columns need to be flipped.
    boolean r1prev = false;
    for (int j = 0; j < M + 1; ++j) {
      boolean r1next = (j == M) ? false : nrow[0][j];
      // If there is a change in the first row, there needs to be a true at the
      // beginning of the column.
      boolean flip_it = (r1next != r1prev) ^ ncol[0][j];
      if (flip_it)
        for (int i = 0; i < N; ++i) {
          ncol[i][j] ^= flip_it;
        }
      r1prev = r1next;
    }
    
    // The values in the first column determine which rows need to be flipped.
    boolean c1prev = false;
    for (int i = 0; i < N + 1; ++i) {
      boolean c1next = (i == N) ? false : ncol[i][0];
      // If there is a change in the first column, there needs to be a true at the
      // beginning of the row.
      boolean flip_it = (c1next != c1prev) ^ nrow[i][0];
      if (flip_it)
        for (int j = 0; j < M; ++j) {
          nrow[i][j] ^= flip_it;
        }
      c1prev = c1next;
    }

    // Check the Eulerian conditon on all the intersections. If the degree of
    // some node is odd, this is not a union of cycles, otherwise it is.
    for (int i = 0; i < N + 1; ++i)
      for (int j = 0; j < M + 1; ++j) {
        int deg = 0;
        if (j > 0 && nrow[i][j - 1]) deg ++;
        if (j < M && nrow[i][j]) deg ++;
        if (i > 0 && ncol[i - 1][j]) deg ++;
        if (i < N && ncol[i][j]) deg ++;
        if ((deg & 1) == 1) return false;
      }
    return true;
  }

  public static void main(String[] args) {
    Scanner scanner = new Scanner(System.in);
    int N = scanner.nextInt();
    int M = scanner.nextInt();
    boolean[][] row = new boolean[N+1][M];
    boolean[][] col = new boolean[N][M+1];
    
    for (int ii = 0; ii < 2; ++ii) {
      for (int i = 0; i < 2 * N + 1; ++i) {
        int r = i / 2;
        boolean is_col = (i & 1) == 1 ? true : false;
        for (int j = 0; j < (is_col ? M + 1 : M); ++j) {
          boolean val = (scanner.nextInt() == 1 ? true : false);
          if (is_col)
            col[r][j] ^= val;
          else
            row[r][j] ^= val;
        }
      }
    }
    // System.out.println(solve(N, M, row, col, false) ? "Yes" : "No");
    // System.out.println(solve(N, M, row, col, true) ? "Yes" : "No");
    boolean result = solve(N, M, row, col, false) || solve(N, M, row, col, true);
    System.out.println(result ? "Yes" : "No");
  }
}
