#from __future__ import annotations
import sys
import math
from collections import Counter
sys.setrecursionlimit(1000000)
def D(a):print(a)
def line():return sys.stdin.readline().strip()
def next_int():return int(line())
def line_ints():return list(map(int,line().split(" ")))

N, X = line_ints()
P = [tuple(line_ints()) for _ in range(N)]
S = set(P)
R = math.ceil(N * X / 100)


def normalize(vx, vy):
    mag = math.hypot(vx, vy)
    if mag == 0:
        return (0.0, 0.0)
    return (vx / mag, vy / mag)


def perpendicular_bisector(a, b):
    if a < b:
        a, b = b, a
    x1, y1 = a
    x2, y2 = b

    mx = (x1 + x2) / 2
    my = (y1 + y2) / 2

    dx = x2 - x1
    dy = y2 - y1

    vx, vy = -dy, dx

    vx, vy = normalize(vx, vy)

    if abs(vx) > 1e-9:
        t = -mx / vx
        px = 0
        py = my + vy * t
    else:
        t = -my / vy
        px = mx + vx * t
        py = 0

    return ((vx, vy), (px, py))


def hash(t):
    return (round(t[0][0], 3), round(t[0][1], 3), round(t[1][0], 3), round(t[1][1], 3))

G = [hash(perpendicular_bisector(a,b)) for a in P for b in P if a != b]
C = Counter(G)
X = max(C.values())
print("YES" if X >= R else "NO")
