import sys
import math
sys.setrecursionlimit(1000000)

def line():
    return sys.stdin.readline().strip()

def line_ints():
    return list(map(int, line().split(" ")))

N, X = line_ints()
P = [tuple(line_ints()) for _ in range(N)]
S = set(P)
R = math.ceil(N * X / 100)

def normalize(vx, vy):
    mag = math.hypot(vx, vy)
    if mag == 0:
        return (0.0, 0.0)
    return (vx / mag, vy / mag)

def perpendicular_bisector(a, b):
    """Get perpendicular bisector of segment ab"""
    if a < b:
        a, b = b, a
    x1, y1 = a
    x2, y2 = b

    mx = (x1 + x2) / 2
    my = (y1 + y2) / 2

    dx = x2 - x1
    dy = y2 - y1

    vx, vy = -dy, dx
    vx, vy = normalize(vx, vy)

    if abs(vx) > 1e-9:
        t = -mx / vx
        px = 0
        py = my + vy * t
    else:
        t = -my / vy
        px = mx + vx * t
        py = 0

    return ((vx, vy), (px, py))

def reflect_across_line(p, line_data):
    """Reflect point p across line defined by (direction, point_on_line)"""
    (vx, vy), (px, py) = line_data

    # Line in form ax + by + c = 0 where (a,b) is normal to direction (vx,vy)
    # Normal is (-vy, vx) if direction is (vx, vy)
    a, b = -vy, vx

    # c = -(a*px + b*py)
    c = -(a * px + b * py)

    x, y = p
    denom = a*a + b*b
    if denom == 0:
        return None

    factor = -2 * (a*x + b*y + c) / denom
    rx = x + factor * a
    ry = y + factor * b

    # Check if result is integer coordinates
    if abs(rx - round(rx)) < 1e-6 and abs(ry - round(ry)) < 1e-6:
        return (round(rx), round(ry))
    return None

def is_on_line(p, line_data):
    """Check if point p is on the line"""
    (vx, vy), (px, py) = line_data
    a, b = -vy, vx
    c = -(a * px + b * py)
    x, y = p
    return abs(a*x + b*y + c) < 1e-6

def hash_line(t):
    return (round(t[0][0], 3), round(t[0][1], 3), round(t[1][0], 3), round(t[1][1], 3))

# Generate all candidate perpendicular bisectors
candidates = {}
for i in range(N):
    for j in range(i+1, N):
        line = perpendicular_bisector(P[i], P[j])
        key = hash_line(line)
        if key not in candidates:
            candidates[key] = line

# For each candidate line, count powerful points
max_powerful = 0
for line_data in candidates.values():
    count = 0
    for p in P:
        if is_on_line(p, line_data):
            continue  # Points on line don't count

        reflection = reflect_across_line(p, line_data)
        if reflection and reflection in S:
            count += 1

    max_powerful = max(max_powerful, count)

print("YES" if max_powerful >= R else "NO")
