#include <bits/stdc++.h>
using namespace std;
using ll=long long;
using ld=double;
using vll=vector<ll>;
using vvll=vector<vector<ll>>;
#define FOR(i,a,b) for(ll i=a;i<(ll)b;++i)
#define F(n) FOR(i,0,n)
#define FF(n) FOR(j,0,n)
#define aa first
#define bb second
#define PB push_back
#define EQ(a,b) (fabs(a-b)<=(fabs(a+b)*EPS))
#define MOD ((ll)(1e9+7))
#define dbg cerr
#define out(n) cout << n << '\n'

//#define dbg if(0)cerr

using Point = pair<ll, ll>;
#define i128 long long


/*
 *  Reflect point P across the line through A and B.
 *  On success:  put the reflected point in R, return true.
 *  If either reflected coordinate is not an integer: return false.
 */




bool getPerpendicularBisector(const Point& A,
                              const Point& B,
                              i128& a, i128& b, i128& c)
{
    i128 dx = (i128)B.first  - A.first;
    i128 dy = (i128)B.second - A.second;
    if (dx == 0 && dy == 0) return false;     // degenerate segment

    // Double the direction to avoid fractions
    a = 2*dx;
    b = 2*dy;

    //   c = −dx(x1 + x2) − dy(y1 + y2)
    c = -dx*((i128)A.first  + B.first)
        -dy*((i128)A.second + B.second);
    return true;
}

/*
 * Reflect point P across the line a·x + b·y + c = 0
 * Returns true if reflection has integer coordinates.
 * Sets is_on_line if P lies on the line.
 */
bool reflectPointAcrossLine(const Point& P,
                            i128 a, i128 b, i128 c,
                            Point& R, bool& is_on_line)
{
    i128 den = a*a + b*b;                 // = |normal|² > 0
    if (den == 0) return false;           // malformed line

    i128 num = a*P.first + b*P.second + c;   // signed distance numerator
    is_on_line = (num == 0);

    i128 rx_num = (i128)P.first  * den - 2 * a * num;
    i128 ry_num = (i128)P.second * den - 2 * b * num;

    if (rx_num % den != 0 || ry_num % den != 0) return false;

    R.first  = (ll)(rx_num / den);
    R.second = (ll)(ry_num / den);
    return true;
}

int main() {
  ios::sync_with_stdio(0);cin.tie(0);
  ll N, P;
  cin>>N>>P;
  if (N <= 2 || P == 0) {
    out("YES");
    return 0;
  }
  vector<pair<ll,ll>> pts(N);
  set<ll> set_pts;

  F(N) {
    cin >> pts[i].aa >> pts[i].bb;
    set_pts.insert((pts[i].aa << 28LL) ^ pts[i].bb);
  }

  
  F(N) {
    for (int j = i + 1; j < N; ++ j) {
      ll cnt = 2;
      ll maxcnt = N;
      ll a, b, c;
      getPerpendicularBisector(pts[i], pts[j], a, b, c);
      for (int k = 0; k < N; ++ k) {
        if (k == i || k == j) continue;
        Point ref;
        bool is_on_line;
        if (reflectPointAcrossLine(pts[k], a, b, c, ref, is_on_line) && !is_on_line) {
          cnt += set_pts.count((ref.aa << 28LL) ^ ref.bb);
          if (100 * cnt >= N * P) {
            out("YES");
            return 0;
          }
        } else {
          maxcnt --;
          if (100 * maxcnt < N * P) {
            break;
          }
        }
      }
    }
  }

  out("NO");

  return 0;
}
