#!/usr/bin/env python3
import sys
from random import Random

def main():
    # Fast I/O
    input = sys.stdin.readline
    N, P = map(int, input().split())

    points = []
    point_set = set()
    for _ in range(N):
        x, y = map(int, input().split())
        points.append((x, y))
        point_set.add((x, y))

    # Build all pairs
    pairs = []
    for i in range(N):
        for j in range(i + 1, N):
            pairs.append((i, j))

    # Shuffle for better average-case (fixed seed for determinism)
    rng = Random(42)
    rng.shuffle(pairs)

    # Try perpendicular bisectors
    for i, j in pairs:
        p1, p2 = points[i], points[j]

        # Perpendicular bisector formula
        dx = p2[0] - p1[0]
        dy = p2[1] - p1[1]

        a = 2 * dx
        b = 2 * dy
        c = -(p2[0] * p2[0] + p2[1] * p2[1] - p1[0] * p1[0] - p1[1] * p1[1])

        # Count powerful points for this line
        powerful_count = 0

        for px, py in points:
            # Check if point is on line
            if a * px + b * py + c == 0:
                continue

            # Calculate mirror reflection
            ax_by_c = a * px + b * py + c
            a2_b2 = a * a + b * b

            numerator_x = 2 * a * ax_by_c
            numerator_y = 2 * b * ax_by_c

            # Check if mirror has integer coordinates
            if numerator_x % a2_b2 != 0 or numerator_y % a2_b2 != 0:
                continue

            mx = px - numerator_x // a2_b2
            my = py - numerator_y // a2_b2

            # Check if mirror is in point set
            if (mx, my) in point_set:
                powerful_count += 1
                # Early exit optimization
                if powerful_count * 100 >= N * P:
                    print("YES")
                    return

    print("NO")

if __name__ == "__main__":
    main()
