#!/usr/bin/env pypy3
import sys
from random import Random

def main():
    # Fast I/O
    N, P = map(int, sys.stdin.readline().split())

    points = []
    point_set = set()
    for _ in range(N):
        x, y = map(int, sys.stdin.readline().split())
        pt = (x, y)
        points.append(pt)
        point_set.add(pt)

    # Pre-compute pairs with indices
    pair_indices = []
    for i in range(N):
        for j in range(i + 1, N):
            pair_indices.append((i, j))

    # Shuffle for better average case
    rng = Random(42)
    rng.shuffle(pair_indices)

    # Cache points as local variables for faster access
    pts = points
    pts_set = point_set
    threshold = N * P

    # Try perpendicular bisectors
    for i, j in pair_indices:
        p1x, p1y = pts[i]
        p2x, p2y = pts[j]

        # Perpendicular bisector coefficients
        dx = p2x - p1x
        dy = p2y - p1y

        a = dx << 1  # 2 * dx (bit shift is faster)
        b = dy << 1  # 2 * dy
        c = -(p2x * p2x + p2y * p2y - p1x * p1x - p1y * p1y)

        # Count powerful points
        count = 0
        a2_b2 = a * a + b * b

        for px, py in pts:
            # Check if on line
            val = a * px + b * py + c
            if val == 0:
                continue

            # Mirror calculation
            num_x = (a * val) << 1  # 2 * a * val
            num_y = (b * val) << 1  # 2 * b * val

            # Check integer coordinates
            if num_x % a2_b2 or num_y % a2_b2:
                continue

            mx = px - num_x // a2_b2
            my = py - num_y // a2_b2

            # Check if mirror in set
            if (mx, my) in pts_set:
                count += 1
                # Early exit
                if count * 100 >= threshold:
                    print("YES")
                    return

    print("NO")

if __name__ == "__main__":
    main()
