#include <iostream>
#include <vector>
#include <set>
#include <cmath>
#include <map>
#include <tuple>

using namespace std;

typedef pair<int, int> Point;

pair<int, int> reflect(const Point& pt, double a, double b, double c) {
    double x = pt.first;
    double y = pt.second;
    double d = a * x + b * y + c;
    double den = a * a + b * b;
    double rx = x - 2 * a * d / den;
    double ry = y - 2 * b * d / den;
    return {static_cast<int>(round(rx)), static_cast<int>(round(ry))};
}

bool check_axis(const set<Point>& points_set, const vector<Point>& points, double a, double b, double c, int P, int N) {
    int count = 0;
    double norm = sqrt(a * a + b * b);

    for (const auto& pt : points) {
        double dist = abs(a * pt.first + b * pt.second + c) / norm;
        if (dist < 1e-9) {
            continue; // Point lies directly on the axis
        }
        auto mirror = reflect(pt, a, b, c);
        if (points_set.count(mirror)) {
            count++;
        }
    }
    return 100 * count >= P * N;
}

int main() {
    int N, P;
    cin >> N >> P;
    vector<Point> points(N);
    set<Point> points_set;

    for (int i = 0; i < N; ++i) {
        int x, y;
        cin >> x >> y;
        points[i] = {x, y};
        points_set.insert(points[i]);
    }

    set<tuple<int64_t, int64_t, int64_t>> tested_axes;

    for (int i = 0; i < N; ++i) {
        for (int j = i + 1; j < N; ++j) {
            int x1 = points[i].first, y1 = points[i].second;
            int x2 = points[j].first, y2 = points[j].second;

            double mx = (x1 + x2) / 2.0;
            double my = (y1 + y2) / 2.0;
            double dx = x2 - x1;
            double dy = y2 - y1;

            double length = sqrt(dx * dx + dy * dy);
            if (length == 0) continue;

            dx /= length;
            dy /= length;

            double a = dx;
            double b = dy;
            double c = -(a * mx + b * my);

            // Normalize key to avoid floating point issues
            int64_t ka = round(a * 1e6);
            int64_t kb = round(b * 1e6);
            int64_t kc = round(c * 1e6);
            auto key = make_tuple(ka, kb, kc);

            if (tested_axes.count(key)) continue;
            tested_axes.insert(key);

            if (check_axis(points_set, points, a, b, c, P, N)) {
                cout << "YES" << endl;
                return 0;
            }
        }
    }
    cout << "NO" << endl;
    return 0;
}
