import math
import sys

best = 0

def reflect(pt, a, b, c):
    # Obraz bodu pt=(x,y) přes přímku ax+by+c=0
    x, y = pt
    d = a * x + b * y + c
    den = a * a + b * b
    rx = x - 2 * a * d / den
    ry = y - 2 * b * d / den
    return (round(rx), round(ry))

def check_axis(points_set, points, a, b, c, P, N):
    global best
    count = 0
    norm = math.sqrt(a * a + b * b)
    
    # print("SSSSSSSS")
    # print("a b c: ", a,b,c)
    
    for pt in points:
        # print("point:", pt)
        dist = abs(a * pt[0] + b * pt[1] + c) / norm
        # print("dist: ", dist)
        if dist < 1e-9:
            # bod leží přímo na ose - nezapočítáváme
            continue
        mirror = reflect(pt, a, b, c)
        # print("mirror: ",mirror)
        if mirror in points_set:
            # print("in_set: ",mirror)
            count += 1
    # print("count:", count)
    if best < 100 * count:
        best = 100 * count    
    return 100 * count >= P * N

def main():
    input = sys.stdin.readline
    N, P = map(int, input().split())
    points = [tuple(map(int, input().split())) for _ in range(N)]
    points_set = set(points)

    tested_axes = set()

    for i in range(N):
        for j in range(i + 1, N):
            x1, y1 = points[i]
            x2, y2 = points[j]
            mx = (x1 + x2) / 2.0
            my = (y1 + y2) / 2.0

            dx = x2 - x1
            dy = y2 - y1

            length = math.sqrt(dx * dx + dy * dy)
            if length == 0:
                continue
            
            dx /= length
            dy /= length

            a = dx
            b = dy

            # a = -dy
            # b = dx

            c = -(a * mx + b * my)
             # zaokrouhlení kvůli stabilitě
            a = round(a * 1e6) / 1e6
            b = round(b * 1e6) / 1e6
            c = round(c * 1e6) / 1e6
            key = (a, b, c)
            # print("key:", key)
            if key in tested_axes:
                continue
            tested_axes.add(key)

            if check_axis(points_set, points, a, b, c, P, N):
                print("YES")
                return
    print("NO")
    # print(best/N)

if __name__ == "__main__":
    main()
