#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

int main() {
    int N, M;
    cin >> N >> M;

    // For each x-coordinate, store segments with endpoint at that x
    // Store as (y, other_x) pairs
    map<int, vector<pair<int, int>>> segments_at_x;

    for (int i = 0; i < M; i++) {
        int xp, yp, xq, yq;
        cin >> xp >> yp >> xq >> yq;

        // Add segment endpoint at xp pointing to xq
        segments_at_x[xp].push_back({yp, xq});
        // Add segment endpoint at xq pointing to xp
        segments_at_x[xq].push_back({yq, xp});
    }

    // Sort segments by y-coordinate for each x
    for (auto& p : segments_at_x) {
        sort(p.second.begin(), p.second.end());
    }

    // Simulate each hunter
    for (int hunter = 1; hunter <= N; hunter++) {
        int current_x = hunter;
        int current_y = 0;

        // Process segments at current_x in order of increasing y
        while (segments_at_x.count(current_x)) {
            bool moved = false;
            for (auto& seg : segments_at_x[current_x]) {
                int seg_y = seg.first;
                int other_x = seg.second;

                if (seg_y > current_y) {
                    // Move to this segment and traverse it
                    current_x = other_x;
                    current_y = seg_y;
                    moved = true;
                    break;
                }
            }
            if (!moved) break;
        }

        cout << current_x << "\n";
    }

    return 0;
}
