#include <bits/stdc++.h>
using namespace std;

using ll = long long;

struct factor
{
    ll p, k;
};

//compute least prime factors of each number from [1,n]
//nloglogn
vector<ll> lp(ll n)
{
    vector<ll> ret(n+1);
    for(ll i = 2; i <= n; ++i)
        ret[i] = i;
    for(ll i = 2; i <= n; ++i)
        if(ret[i] == i)
            for(ll j = 2 * i; j <= n; j += i)
                if(ret[j] == j)
                    ret[j] = i;
    return ret;
}
//compute factorization of everything in [1,n]
//n^(1+eps)
vector<vector<factor>> factorize(ll n)
{
    auto lf = lp(n);
    vector<vector<factor>> ret(n+1);
    for(ll i = 2; i <= n; ++i)
    {
        ll x = i;
        while(x != 1)
        {
            if(ret[i].empty() || ret[i].back().p != lf[x])
                ret[i].push_back(factor{lf[x],1});
            else
                ret[i].back().k++;
            x /= lf[x];
        }
    }
    return ret;
}

int main()
{
    int n, k;
    cin >> n >> k;
    vector<int> a(n);
    for(int i = 0; i < n; ++i)
        cin >> a[i];
    auto facts = factorize(500000);
    
    
    int l = 0, r = -1;
    map<ll,int> occ;
    ll pairs = 0;
    ll tot = 0;
    while(l < n && r < n)
    {
        if(pairs >= k)
        {
            tot += n - r;
            //remove a[l]
            
            for(int mask = 1; mask < (1 << facts[a[l]].size()); ++mask)
            {
                ll prod = 1;
                for(int i = 0; i < facts[a[l]].size(); ++i)
                    if((1<<i)&mask)
                        prod *= facts[a[l]][i].p;
                --occ[prod];
            }
            
            for(int mask = 1; mask < (1 << facts[a[l]].size()); ++mask)
            {
                ll prod = 1;
                for(int i = 0; i < facts[a[l]].size(); ++i)
                    if((1<<i)&mask)
                        prod *= facts[a[l]][i].p;
                
                if(__builtin_popcount(mask)&1) //odd +, even -
                    pairs -= occ[prod];
                else
                    pairs += occ[prod];
            }
            
            
            ++l;
        }
        else
        {
            ++r;
            //add a[r]
            for(int mask = 1; mask < (1 << facts[a[r]].size()); ++mask)
            {
                ll prod = 1;
                for(int i = 0; i < facts[a[r]].size(); ++i)
                    if((1<<i)&mask)
                        prod *= facts[a[r]][i].p;
                
                if(__builtin_popcount(mask)&1) //odd +, even -
                    pairs += occ[prod];
                else
                    pairs -= occ[prod];
            }
            for(int mask = 1; mask < (1 << facts[a[r]].size()); ++mask)
            {
                ll prod = 1;
                for(int i = 0; i < facts[a[r]].size(); ++i)
                    if((1<<i)&mask)
                        prod *= facts[a[r]][i].p;
                ++occ[prod];
            }
            
        }
        
    }
    
    cout << tot << endl;
    
    
}