#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

const int MAXN = 500001;
int spf[MAXN];

void sieve() {
    for (int i = 0; i < MAXN; i++) spf[i] = i;
    for (int i = 2; i * i < MAXN; i++) {
        if (spf[i] == i) {
            for (int j = i * i; j < MAXN; j += i) {
                if (spf[j] == j) spf[j] = i;
            }
        }
    }
}

vector<int> get_primes(long long n) {
    vector<int> primes;
    while (n > 1) {
        int p = spf[n];
        primes.push_back(p);
        while (n % p == 0) n /= p;
    }
    return primes;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    sieve();

    int N;
    long long K;
    cin >> N >> K;

    vector<long long> A(N);
    vector<vector<int>> primes(N);

    for (int i = 0; i < N; i++) {
        cin >> A[i];
        primes[i] = get_primes(A[i]);
    }

    long long result = 0;
    long long quality = 0;
    unordered_map<long long, int> counts;
    counts.reserve(2048);

    int L = 0, R = 0;

    while (L < N) {
        // Extend R while quality < K
        while (R < N && quality < K) {
            // Add element R using inclusion-exclusion
            int d = primes[R].size();
            if (d > 0 && R > L) {
                // Count pairs with elements in [L, R-1]
                long long pairs_added = 0;
                for (int mask = 1; mask < (1 << d); mask++) {
                    long long product = 1;
                    int bits = 0;
                    for (int i = 0; i < d; i++) {
                        if (mask & (1 << i)) {
                            product *= primes[R][i];
                            bits++;
                        }
                    }
                    int sign = (bits % 2 == 1) ? 1 : -1;
                    pairs_added += sign * counts[product];
                }
                quality += pairs_added;
            }

            // Add R to counts
            for (int mask = 1; mask < (1 << primes[R].size()); mask++) {
                long long product = 1;
                for (int i = 0; i < primes[R].size(); i++) {
                    if (mask & (1 << i)) {
                        product *= primes[R][i];
                    }
                }
                counts[product]++;
            }

            R++;
        }

        // If quality >= K, count all extensions
        if (quality >= K) {
            result += (N - R + 1);
        }

        // Remove element L
        if (L < R) {
            // Remove L from counts
            for (int mask = 1; mask < (1 << primes[L].size()); mask++) {
                long long product = 1;
                for (int i = 0; i < primes[L].size(); i++) {
                    if (mask & (1 << i)) {
                        product *= primes[L][i];
                    }
                }
                counts[product]--;
            }

            // Recalculate pairs lost by removing L
            // L was paired with elements in [L+1, R-1]
            if (primes[L].size() > 0) {
                long long pairs_lost = 0;
                for (int mask = 1; mask < (1 << primes[L].size()); mask++) {
                    long long product = 1;
                    int bits = 0;
                    for (int i = 0; i < primes[L].size(); i++) {
                        if (mask & (1 << i)) {
                            product *= primes[L][i];
                            bits++;
                        }
                    }
                    int sign = (bits % 2 == 1) ? 1 : -1;
                    pairs_lost += sign * counts[product];
                }
                quality -= pairs_lost;
            }
        }

        L++;

        // Handle edge case: if L == R, reset
        if (L == R && R < N) {
            quality = 0;
            counts.clear();
        }
    }

    cout << result << endl;

    return 0;
}
