#include <iostream>
#include <vector>

using namespace std;

const long long MOD = 1000000007;

// Precompute factorials and inverse factorials
vector<long long> fact, inv_fact;

long long power(long long a, long long b, long long mod) {
    long long res = 1;
    a %= mod;
    while (b > 0) {
        if (b & 1) res = (res * a) % mod;
        a = (a * a) % mod;
        b >>= 1;
    }
    return res;
}

void precompute(int maxn) {
    fact.resize(maxn + 1);
    inv_fact.resize(maxn + 1);

    fact[0] = 1;
    for (int i = 1; i <= maxn; i++) {
        fact[i] = (fact[i-1] * i) % MOD;
    }

    inv_fact[maxn] = power(fact[maxn], MOD - 2, MOD);
    for (int i = maxn - 1; i >= 0; i--) {
        inv_fact[i] = (inv_fact[i+1] * (i+1)) % MOD;
    }
}

long long C(int n, int k) {
    if (k < 0 || k > n) return 0;
    return (fact[n] * inv_fact[k] % MOD) * inv_fact[n-k] % MOD;
}

int main() {
    int n;
    cin >> n;

    precompute(4 * n);

    long long answer = 0;

    // Inclusion-exclusion: at least one row has all ducks
    // If k rows have all ducks, we need 4k ducks from our 2n ducks
    // Remaining (2n - 4k) ducks go in remaining 4(n-k) positions
    // along with 2n hares

    for (int k = 1; k <= n && 4*k <= 2*n; k++) {
        // Choose which k rows have all ducks
        long long ways = C(n, k);

        // Arrange remaining (2n - 4k) ducks in remaining 4(n-k) positions
        ways = (ways * C(4 * (n - k), 2*n - 4*k)) % MOD;

        // Inclusion-exclusion sign
        if (k % 2 == 1) {
            answer = (answer + ways) % MOD;
        } else {
            answer = (answer - ways + MOD) % MOD;
        }
    }

    cout << answer << endl;

    return 0;
}
