#include <bits/stdc++.h>

typedef long long ll;

using namespace std;

ll power(ll x, ll y, ll p) {
    ll res = 1;

    x = x % p;

    if (x == 0) return 0;

    while (y > 0) {
        if (y & 1)
            res = (res * x) % p;

        y = y >> 1;
        x = (x * x) % p;
    }
    return res;
}


vector<ll> factorial, inv;
ll prime = 1000000007;

ll binom(ll n, ll k) {
    return (((factorial[n] * inv[k]) % prime) * inv[n - k]) % prime;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    ll n;
    cin >> n;

    factorial.resize(4 * n + 1);
    inv.resize(4 * n + 1);
    factorial[0] = 1;
    for (ll i = 1; i <= 4 * n; i++) {
        factorial[i] = (factorial[i - 1] * i) % prime;
    }
    for (int i = 0; i <= 4 * n; ++i) {
        inv[i] = power(factorial[i], prime - 2, prime);
    }

    ll ans = 0;
    for (int i = 1; i <= n / 2; ++i) {
        if (i % 2 == 1) ans = (ans + (binom(n, i) * binom(4 * n - 4 * i, 2 * n)) % prime) % prime;
        else ans = (prime + ans - (binom(n, i) * binom(4 * n - 4 * i, 2 * n)) % prime) % prime;
    }

    cout << ans << endl;

    return 0;
}