import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;

/**
 * ICPC - CTU Open Contest 2025
 * Wrong Solution: Archery
 * 
 * Find one connected component and do one move for all the remaining vertices.
**/

public class ArcheryWA {

  static class Vertex {
    boolean visited = false;
    List<Integer> neighs;
    int x, y;
    int index;
    Vertex() {
      neighs = new ArrayList<>();
    }
  }

  static class Graph {
    Vertex[] v;

    Graph(int N) {
      v = new Vertex[N];
      for (int i = 0; i < N; ++i) {
        v[i] = new Vertex();
        v[i].index = i;
      }
    }
    
    public void bfs(int start) {
      Queue<Integer> q = new LinkedList<>();
      q.add(start);
      v[start].visited = true;
      while (!q.isEmpty()) {
        int cur = q.remove();
        for (int i : v[cur].neighs) {
          if (v[i].visited)
            continue;
          q.add(i);
          v[i].visited = true;
        }
      }
    }
  }

  public static void main(String[] args) {
    Scanner scanner = new Scanner(System.in);
    int N = scanner.nextInt();

    Graph g = new Graph(N);

    for (int i = 0; i < N; ++i) {
      g.v[i].x = scanner.nextInt();
      g.v[i].y = scanner.nextInt();
    }

    // Find vertical neighbors.
    Arrays.sort(g.v, (a, b) -> Integer.compare(a.x, b.x));
    for (int i = 1; i < N; ++i)
      // There's a clique on vertices with the same x coordinate. Take only a path,
      // because we're only interested in finding connected components.
      if (g.v[i - 1].x == g.v[i].x) {
        g.v[i - 1].neighs.add(g.v[i].index);
        g.v[i].neighs.add(g.v[i - 1].index);
      }

    // Find horizontal neighbors.
    Arrays.sort(g.v, (a, b) -> Integer.compare(a.y, b.y));
    for (int i = 1; i < N; ++i)
      if (g.v[i - 1].y == g.v[i].y) {
        g.v[i - 1].neighs.add(g.v[i].index);
        g.v[i].neighs.add(g.v[i - 1].index);
      }
    
    Arrays.sort(g.v, (a, b) -> Integer.compare(a.index, b.index));

    g.bfs(0);
    int result = 0;
    
    for (int i = 0; i < N; ++i)
      if (!g.v[i].visited)
        ++result;

    System.out.println(result);
  }
}
