#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

class UnionFind {
public:
    unordered_map<long long, long long> parent;
    unordered_map<long long, int> rank;

    long long find(long long x) {
        if (!parent.count(x)) {
            parent[x] = x;
            rank[x] = 0;
        }
        if (parent[x] != x) {
            parent[x] = find(parent[x]);
        }
        return parent[x];
    }

    void unite(long long x, long long y) {
        long long px = find(x);
        long long py = find(y);

        if (px == py) return;

        if (rank[px] < rank[py]) {
            parent[px] = py;
        } else if (rank[px] > rank[py]) {
            parent[py] = px;
        } else {
            parent[py] = px;
            rank[px]++;
        }
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    cin >> N;

    vector<pair<long long, long long>> rooks(N);
    UnionFind uf;

    for (int i = 0; i < N; i++) {
        cin >> rooks[i].first >> rooks[i].second;
    }

    // Union rooks by rows and columns
    // Use large offset for columns to distinguish from rows
    // Coordinates are in [-10^9, 10^9], so offset by 10^10
    const long long COL_OFFSET = 10000000000LL;

    for (int i = 0; i < N; i++) {
        long long row = rooks[i].first;
        long long col = rooks[i].second + COL_OFFSET; // Offset columns

        uf.unite(row, col);
    }

    // Count connected components
    unordered_map<long long, bool> seen;
    int components = 0;

    for (int i = 0; i < N; i++) {
        long long root = uf.find(rooks[i].first);
        if (!seen[root]) {
            seen[root] = true;
            components++;
        }
    }

    cout << components - 1 << endl;

    return 0;
}
